function ArgumentURL() {
	this.initArgument = _initArg;
	this.resetArgument = _resetArg;
	this.getArgument = _getArg;
	this.setArgument = _setArg;
	this.removeArgument = _removeArg;
	this.selectedOption = _selectOption;
	this.toString    = _toString;	//Allows the object to be printed
									//no need to write toString()
	this.arguments   = new Array();

	// Initiation
	var separator = "&";
	var equalsign = "=";
	
	function _toString() {
		var s = "";
		for (i in this.arguments) {
			s += this.arguments[i].name;
			s += equalsign;
			s += this.arguments[i].value;
			s += separator;
		}
		return s.replace(/ /g, "%20");
	}
	
	function _getArg(name) {
		if (typeof(this.arguments[name].name) != "string")
			return null;
		else
			return this.arguments[name].value;
	}
	
	function _setArg(name,value) {
		this.arguments[name] = new Object()
		this.arguments[name].name = name;
		this.arguments[name].value = escape(value);
	}
	
	function _removeArg(name) {
		this.arguments[name] = null;
	}
	
	function _initArg() {
		var name;
		var value;
		var type;
		
		//input ==> checkbox,hidden,text,radio
		var objs = document.getElementsByTagName("input");
		for (var i = 0; i < objs.length; i++) {
			name = objs[i].name;
    	value = objs[i].value;
    	type = objs[i].type;
    	
    	if (type == "checkbox") {
    		value = objs[i].checked ? 1 : 0;
    	}
    	if ((type == "checkbox") || (type == "hidden") || (type == "text") || (type == "radio")) {
    		this.setArgument(name, value);
    	}
  	}
  	
  	// select
  	var selObjs = document.getElementsByTagName("select");
  	for (var j = 0; j < selObjs.length; j++) {
  		name = selObjs[j].name;
  		value = selObjs[j].options.selectedIndex;
			this.setArgument(name, value);
  	}
	}
	
	function _resetArg(str) {
		var infoArray = new Array();		
		infoArray = str.split(separator);

		var tmp;
		var name;
		var value;
		var obj;
		
		for (var i=0; i<infoArray.length; i++) {
			tmp = infoArray[i].split(equalsign);
			if (tmp[0] == "") {
				continue;
			}

			name = tmp[0];
			value = unescape(tmp[1]);
			this.setArgument(name, value);

			var aInput=document.getElementsByName(name);
			if (aInput.length <= 0) {
				continue;
			}
			obj = aInput[0];
			if (obj.tagName == "INPUT") {
				if ((obj.type == "hidden") || (obj.type == "text")) {
					obj.value = value;
				} else if ((obj.type == "checkbox") || (obj.type == "radio")) {
					_setCheckBoxValue(obj, value);
				}	else {
				
				}
			} else if (obj.tagName == "SELECT") {
				_setSelectValue(obj, value);
			}
		}
	}

	function _setCheckBoxValue(obj, value) {
		if (value == "1") {
			obj.checked = true;
		} else {
			obj.checked = false;
		}
	}
	
	function _setSelectValue(obj, value) {
		if (obj.options.length <= value) {
			return;
		}
		
		obj.options[value].selected = true;
	}
	
	function _selectOption(key) {
		var aInput = document.getElementsByName(key);
		if (aInput.length <= 0) {
			return;
		}
		
		var value = this.getArgument(key);
		
		_setSelectValue(aInput[0], value);
	}
	
	return this;
}